import { ApplicationShell } from "@/components/layout/application.shell";
import { nextjsRedirectUserGuard } from "@/features/auth/lib/guards";

export default async function UnauthorizedLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  await nextjsRedirectUserGuard()

  return (
    <ApplicationShell>
      {{
        content: children,
        sidebar: null,
        header: null,
      }}
    </ApplicationShell>
  );
}


